$(function() {
	/* 禁止文本选择 */
	document.onselectstart = new Function("return false");
	document.ondragstart = new Function("return false");
	
	clean.init(); // 勾选上次的选项
	
	// 设置close-button的淡入淡出
	$('#close-button').append('<span class="hover"></span>').hover(function() {
	    view.fadeButtonIn.apply(this);
	}, function() {
		var el = this;
	    
		setTimeout(function() {
			if (!el.open) view.fadeButtonOut.apply(el);
		}, 10);
	}).click(function() {
		qqbrowser.dialog.close(0); // 关闭页面
	}); 

	$('#close-bottom-button').click(function() {
		qqbrowser.dialog.close(0); // 关闭页面
	});
	
	$('#clean-button').click(function() {
		clean.excute();
	});
	
	// 根据options显示取消或者开启
	qqbrowser.extension.builtin.config.get(["autoClean"], clean.initAutoClean);

	$('#clean-button').focus();
});

var daPosition = 0;
var timeOutIdle;
var waitingAnimateList = new Array('images/loading/1.png' , 
		'images/loading/2.png' , 'images/loading/3.png' , 
		'images/loading/4.png' , 'images/loading/5.png' ,
		'images/loading/6.png' , 'images/loading/7.png' , 
		'images/loading/8.png' , 'images/loading/9.png' ,
		'images/loading/10.png' , 'images/loading/11.png');

var clean = {};

clean.initAutoClean = function(results) {
	var options = eval('(' + results + ')');

	if(options.length > 0 && options[0].autoClean) {
		$('#auto-clean-checkbox').attr('checked', true);
//		$('#auto-clean-open').hide();
	} else {
//		$('#auto-clean-close').hide();
		$('#auto-clean-checkbox').attr('checked', false);
	}

	$('#auto-clean-checkbox').change(function() {
		var obj = qqbrowser.extension.dllLoader('clean.dll');

		if($('#auto-clean-checkbox').attr('checked')) {
			obj.execDllFunc("setAutoClean", 1);	
		} else {
			obj.execDllFunc("setAutoClean", 0);	
		}
	});

/*	$('#auto-clean-open').click(function() {
		var obj = qqbrowser.extension.dllLoader('clean.dll');
		obj.execDllFunc("setAutoClean", 1);	

//		$('#auto-clean-open').hide();
//		$('#auto-clean-close').show();
	});
	
	$('#auto-clean-close').click(function() {
		var obj = qqbrowser.extension.dllLoader('clean.dll');
		obj.execDllFunc("setAutoClean", 0);	

//		$('#auto-clean-open').show();
//		$('#auto-clean-close').hide();
	});	*/
}

/**
 * 执行清理
 */
clean.excute = function() {
	try
	{
		var checkboxs = $('input[type="checkbox"]');
		for(var i = 0; i < checkboxs.length; i++) {
			if($(checkboxs[i]).attr('checked')) { // 选中一个后才执行下面的方法
				clean.showWaitingAnimate();
					// 增加一个读取清理时间的读取
				if($(checkboxs[6]).attr('checked')) {
					var sites = [];
					var constants = function(){
						var emptydata ={
							url: 'javascript:void(0)',
							title: '',
							image: 'images/1_normal.png', 
							icon: ''
						};
						this.data = function(i){
							var index = i+1 || 1;
							emptydata.image = 'images/'+index+'_normal.png';
							return emptydata;
						};
					};
					for(var i=0;i<9;i++){
						sites[i] = (new constants()).data(i);
					}
					var json = [];
					for(var i=0;i<sites.length; i++){
						json[json.length] = sites[i]; 
					}
					localStorage.setItem('topSites', JSON.stringify(json));
				}				
				var obj = qqbrowser.extension.dllLoader('clean.dll');
				obj.execDllFunc("execClean", 'clean.showDone');	
				return;
			}
		}
	} catch (e)	{
//		alert(e.message);
	}
}


/**
 * 初始化
 */
clean.init = function() {
	// 初始化勾选数据
	try {
	    var obj = qqbrowser.extension.dllLoader('clean.dll');
	    obj.execDllFunc("getCleanOption", 'clean.selectCheckbox');
	    
		// 勾选时需通知浏览器
		var checkboxs = $('.clean-body input[type="checkbox"]');
		for(var i = 0; i < checkboxs.length; i++) {
			var checkbox = $(checkboxs[i]);

			checkbox.bind('click', {index: i}, function(param) {
				var index = param.data['index'];
				var isChecked = $(this).attr('checked') ? 1 : 0;

//				alert(Math.pow(2, index) + ' ' + isChecked);
				// 设置浏览器选项
				var obj = qqbrowser.extension.dllLoader('clean.dll');

				// setCleanOption(uTraceType, bCheck)
				obj.execDllFunc("setCleanOption", Math.pow(2, index), isChecked);
				clean.checkCleanStatus();
			});
		}
		
		$('#selectAll').change(function() {
			var cleanButton = document.getElementById("clean-button"),
				obj = qqbrowser.extension.dllLoader('clean.dll'),
				isChecked = $(this).attr('checked'),
				checkboxs = $('.clean-body input[type="checkbox"]');
				
			obj.execDllFunc('setAllCleanOptions', isChecked ? 1 : 0);
			if (isChecked) {
				cleanButton.disabled = '';
				cleanButton.style.opacity = 1;
			} else {
				cleanButton.disabled = 'disabled';
				cleanButton.style.opacity = 0.4;
			}
			
			checkboxs.each(function(index) {
				$(this).attr('checked', Boolean(isChecked));
			});
		});
	} catch(e) {
//		do nothing	d
//		alert(e.message);
	}
}

/*clean.init = function() {
	// 初始化勾选数据
	try {
	    var obj = qqbrowser.extension.dllLoader('clean.dll');
	    obj.execDllFunc("getCleanOption", 'clean.selectCheckbox');
	    
	    // setCleanOption(uTraceType, bCheck)
		var checkboxs = $('input[type="checkbox"]');
		for(var i = 0; i < checkboxs.length; i++) {
			var checkbox = $(checkboxs[i]);

			var d = new delegate(i, checkbox);
			checkboxs[i].onclick = d.checkboxClick;
		}
	} catch(e) {
//		do nothing	
		alert(e.message);
	}
}

function delegate(index, checkbox) {
	this.checkboxClick = function() {
		var isChecked = checkbox.attr('checked');
		alert(Math.pow(2, index) + ' ' + isChecked);
	};
}*/

/**
 * 选择上次勾选的数据
 */
clean.selectCheckbox = function(data) {
	var optionValue = eval('(' + data + ')')[0];
	var dateValue = JSON.parse(data)[1];
	var select = document.getElementById("clearBrowserDataTimePeriod");
	
	select.value = dateValue;
	
	var checkboxs = $('.clean-body input[type="checkbox"]');
	for(var i = 0; i < checkboxs.length; i++) {
		if(Math.pow(2, i) & optionValue) {
			$(checkboxs[i]).attr('checked', true);
		}
	}
	
	// 根据checkbox的状态决定clean-button的状态，以及全选checkbox的状态
	clean.checkCleanStatus();
}

clean.checkCleanStatus = function() {
	var checkboxs = $('.clean-body input[type="checkbox"]');
	var cleanButton = document.getElementById("clean-button");

	// 如果所有checkbox都选中，那么全选checkbox也选中
	if (checkboxs.toArray().every(function(element, index, array) {return $(element).attr('checked');})) {
		$('#selectAll').attr('checked', true);
	} else {
		$('#selectAll').attr('checked', false);
	}
	
	// 如果至少有一个checkbox选中，enable“清理”button
	if (checkboxs.toArray().some(function(element, index, array) {return $(element).attr('checked');})) {
		cleanButton.disabled = '';
		cleanButton.style.opacity = 1;
	// disable“清理”button
	} else {
		cleanButton.disabled = 'disabled';
		cleanButton.style.opacity = 0.4;
	}
}

/**
 * 显示waiting
 */
clean.showWaitingAnimate = function() {
	// 屏蔽按钮
	$('#clean-button').attr('disabled', 'disabled').addClass('disabled');
	
	// 显示等待栏
	$('#waiting').show();
	
	clean.controlWaitingAnimate();
}

/**
 * 控制动画图片的显示
 */
clean.controlWaitingAnimate = function() {
	clean.controlWaitingImg();
}

clean.controlWaitingImg = function() {
	daPosition = daPosition == waitingAnimateList.length - 1 ? 0 : ++daPosition;
	
	$('#waiting-animate-image').attr('src', waitingAnimateList[daPosition]);

	timeOutIdle = setTimeout("clean.controlWaitingAnimate()", 100);
}


/**
 * 显示完成
 */
clean.showDone = function() {
	// clear动画控制
	clearTimeout(timeOutIdle);
	// 
	$('#waiting').hide();
	
	$('#done').show();
	
	$('#clean-button').hide();
	$('#close-bottom-button').show();
}

function dateChange() {
	var obj = qqbrowser.extension.dllLoader('clean.dll');
	var v = parseInt(document.getElementById("clearBrowserDataTimePeriod").value);
	
	var checkboxs = $('.clean-body input[type="checkbox"]');
	var isChecked = checkboxs[0].checked ? 1 : 0;
	
	obj.execDllFunc("setCleanOption", Math.pow(2, 0), isChecked, v);
}